<?php
/**
	*
	* @author     Gaviasthemes     
	* @copyright  Copyright (C) 2024 Gaviasthemes. All Rights Reserved.
	* @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
	* 
*/

define('WELLEARN_THEME_DIR', get_template_directory());
define('WELLEARN_THEME_URL', get_template_directory_uri());

// Include list of files of theme.
require_once(WELLEARN_THEME_DIR . '/includes/functions.php'); 
require_once(WELLEARN_THEME_DIR . '/includes/template.php'); 
require_once(WELLEARN_THEME_DIR . '/includes/hook.php'); 
require_once(WELLEARN_THEME_DIR . '/includes/layout.php'); 
require_once(WELLEARN_THEME_DIR . '/includes/comment.php'); 
require_once(WELLEARN_THEME_DIR . '/includes/metaboxes.php');
require_once(WELLEARN_THEME_DIR . '/includes/customize.php'); 
require_once(WELLEARN_THEME_DIR . '/includes/menu.php'); 
require_once(WELLEARN_THEME_DIR . '/includes/elementor/hooks.php');

//Load Woocommerce plugin
if(class_exists('WooCommerce')){
	add_theme_support('woocommerce');
	require_once(WELLEARN_THEME_DIR . '/includes/woocommerce/functions.php'); 
	require_once(WELLEARN_THEME_DIR . '/includes/woocommerce/hooks.php'); 
}

if(function_exists('tutor')){
	require_once(WELLEARN_THEME_DIR . '/includes/tutor/hooks.php'); 
}

add_action('after_setup_theme', 'wellearn_after_setup_theme');
function wellearn_after_setup_theme(){
	// Load Redux - Theme options framework
	if(class_exists('Redux')){
		require(WELLEARN_THEME_DIR . '/includes/options/init.php');
		require_once(WELLEARN_THEME_DIR . '/includes/options/opts-general.php'); 
		require_once(WELLEARN_THEME_DIR . '/includes/options/opts-footer.php'); 
		require_once(WELLEARN_THEME_DIR . '/includes/options/opts-styling.php'); 
		require_once(WELLEARN_THEME_DIR . '/includes/options/opts-page.php'); 
		require_once(WELLEARN_THEME_DIR . '/includes/options/opts-course.php'); 
		require_once(WELLEARN_THEME_DIR . '/includes/options/opts-blog.php'); 
		require_once(WELLEARN_THEME_DIR . '/includes/options/opts-portfolio.php'); 
		if(class_exists('WooCommerce')){
			require_once(WELLEARN_THEME_DIR . '/includes/options/opts-woo.php'); 
		}
	}
	//	Registry menu
	register_nav_menus( array(
		'primary'      => esc_html__( 'Main menu', 'wellearn' ),
	));
}

// TGM plugin activation
if (is_admin()) {
	require_once(WELLEARN_THEME_DIR . '/includes/tgmpa/class-tgm-plugin-activation.php');
	require(WELLEARN_THEME_DIR . '/includes/tgmpa/config.php');
}
load_theme_textdomain('wellearn', get_template_directory() . '/languages');

//-------- Register sidebar default in theme -----------
//------------------------------------------------------
function wellearn_widgets_init() {
	register_sidebar(array(
		'name' 				=> esc_html__('Default Sidebar', 'wellearn'),
		'id' 					=> 'default_sidebar',
		'description' 		=> esc_html__('Appears in the Default Sidebar section of the site.', 'wellearn'),
		'before_widget' 	=> '<aside id="%1$s" class="widget clearfix %2$s">',
		'after_widget' 	=> '</aside>',
		'before_title' 	=> '<h3 class="widget-title"><span>',
		'after_title' 		=> '</span></h3>',
	));

	if(class_exists('WooCommerce')){
		register_sidebar( array(
			'name' 				=> esc_html__('WooCommerce Shop Sidebar', 'wellearn'),
			'id' 					=> 'woocommerce_sidebar',
			'description' 		=> esc_html__('Appears in the Plugin WooCommerce section of the site.', 'wellearn'),
			'before_widget' 	=> '<aside id="%1$s" class="widget clearfix %2$s">',
			'after_widget'	 	=> '</aside>',
			'before_title' 	=> '<h3 class="widget-title"><span>',
			'after_title' 		=> '</span></h3>',
		));
	}
	register_sidebar(array(
		'name' 				=> esc_html__('After Offcanvas Mobile', 'wellearn'),
		'id' 					=> 'offcanvas_sidebar_mobile',
		'description' 		=> esc_html__('Appears in the Offcanvas section of the site.', 'wellearn'),
		'before_widget' 	=> '<aside id="%1$s" class="widget clearfix %2$s">',
		'after_widget' 	=> '</aside>',
		'before_title' 	=> '<h3 class="widget-title"><span>',
		'after_title' 		=> '</span></h3>',
	));
	register_sidebar(array(
		'name' 				=> esc_html__('Blog Sidebar', 'wellearn'),
		'id' 					=> 'blog_sidebar',
		'description' 		=> esc_html__('Appears in the Blog sidebar section of the site.', 'wellearn'),
		'before_widget' 	=> '<aside id="%1$s" class="widget clearfix %2$s">',
		'after_widget' 	=> '</aside>',
		'before_title' 	=> '<h3 class="widget-title"><span>',
		'after_title' 		=> '</span></h3>',
	));
	if(function_exists('tutor')){
		register_sidebar(array(
			'name' 					=> esc_html__('Archive Course Sidebar', 'wellearn'),
			'id' 						=> 'archive_course_sidebar',
			'description' 			=> esc_html__('Appears in the Archive Course Page Sidebar section of the site.', 'wellearn'),
			'before_widget' 		=> '<aside id="%1$s" class="widget clearfix %2$s">',
			'after_widget' 		=> '</aside>',
			'before_title' 		=> '<h3 class="widget-title"><span>',
			'after_title' 			=> '</span></h3>',
		));
	}
	
}
add_action('widgets_init', 'wellearn_widgets_init');


function wellearn_fonts_url() { 
	$fonts_url = '';
	$fonts     = array();
	$subsets   = '';
	$protocol = is_ssl() ? 'https' : 'http';
	if('off' !== _x('off', 'Nunito Sans font: on or off', 'wellearn')){
		$fonts[] = 'Nunito+Sans:ital,opsz,wght@0,6..12,200..1000;1,6..12,200..1000';
	}
	if($fonts){
		$fonts_url = add_query_arg( array(
			'family' => (implode('&family=', $fonts)),
			'display' => 'swap',
		),  $protocol.'://fonts.googleapis.com/css2');
	}
	return $fonts_url;
}

function wellearn_custom_styles() {
	$custom_css = get_option('wellearn_theme_custom_styles');
	if($custom_css){
		wp_enqueue_style(
			'wellearn-custom-style',
			WELLEARN_THEME_URL . '/assets/css/custom_script.css'
		);
		wp_add_inline_style('wellearn-custom-style', $custom_css);
	}
}
add_action('wp_enqueue_scripts', 'wellearn_custom_styles', 9999);

function wellearn_init_scripts(){
	global $post;
	$protocol = is_ssl() ? 'https' : 'http';
	if ( is_singular() && comments_open() && get_option('thread_comments') ){
		wp_enqueue_script('comment-reply');
	}

	$theme = wp_get_theme('wellearn');
	$theme_version = $theme['Version'];

	wp_enqueue_style('wellearn-fonts', wellearn_fonts_url(), array(), null );
	
	wp_enqueue_script('bootstrap', WELLEARN_THEME_URL . '/assets/js/bootstrap.min.js', array('jquery') );
	wp_enqueue_script('perfect-scrollbar', WELLEARN_THEME_URL . '/assets/js/perfect-scrollbar.jquery.min.js');
	wp_enqueue_script('jquery-magnific-popup', WELLEARN_THEME_URL . '/assets/js/magnific/jquery.magnific-popup.min.js');
	wp_enqueue_script('jquery-cookie', WELLEARN_THEME_URL . '/assets/js/jquery.cookie.js', array('jquery'));
	wp_enqueue_script('swiper', WELLEARN_THEME_URL . '/assets/js/swiper/swiper.min.js');
	wp_enqueue_script('jquery-appear', WELLEARN_THEME_URL . '/assets/js/jquery.appear.js');
	wp_enqueue_script('wellearn-main', WELLEARN_THEME_URL . '/assets/js/main.js', array('imagesloaded', 'jquery-masonry'), $theme_version);
	wp_enqueue_style('dashicons');
	wp_enqueue_style('swiper', WELLEARN_THEME_URL .'/assets/js/swiper/swiper.min.css');
	wp_enqueue_style('magnific', WELLEARN_THEME_URL .'/assets/js/magnific/magnific-popup.css');
	wp_enqueue_style('fontawesome', WELLEARN_THEME_URL . '/assets/css/fontawesome/css/all.min.css');

	wp_enqueue_style('wellearn-style', WELLEARN_THEME_URL . '/style.css');
	wp_enqueue_style('bootstrap', WELLEARN_THEME_URL . '/assets/css/bootstrap.css', array(), $theme_version , 'all'); 
	wp_enqueue_style('wellearn-template', WELLEARN_THEME_URL . '/assets/css/template.css', array(), $theme_version , 'all');
	wp_enqueue_style('wellearn-course', WELLEARN_THEME_URL . '/assets/css/course.css', array(), $theme_version , 'all');
	
	//Woocommerce
	if(class_exists('WooCommerce')){
		wp_enqueue_style('wellearn-woocoomerce', WELLEARN_THEME_URL . '/assets/css/woocommerce.css', array(), $theme_version , 'all'); 
		wp_dequeue_script('wc-add-to-cart');
		wp_enqueue_script('wc-add-to-cart', WELLEARN_THEME_URL . '/assets/js/add-to-cart.js' , array('jquery'));
	}
} 

add_action('wp_enqueue_scripts', 'wellearn_init_scripts', 999);
