<?php
/**
 * @package TutorLMS/Templates
 * @version 1.4.3
 */

global $post, $authordata;

$cats_html = '';
$course_categories = get_tutor_course_categories();
$i = 0;
if(!empty($course_categories) && is_array($course_categories ) && count($course_categories)){
   foreach ($course_categories as $course_category){
      $i++;
      $category_name = $course_category->name;
      $category_link = get_term_link($course_category->term_id);
      $cats_html .= "<a class='cat-link' href='$category_link'>$category_name</a>";
      if($i < count($course_categories)) $cats_html .= ',&nbsp;';
   }
}

$profile_url = tutor_utils()->profile_url($authordata->ID, true);
$author_html = '<a href="' . esc_url($profile_url) . '">' . get_the_author() . '</a>';
?>

<div class="course-loop-meta">
    <div class="content-inner">
        <a class="author-avatar" href="<?php echo esc_url($profile_url); ?>"> <?php echo tutor_utils()->get_tutor_avatar($post->post_author); ?></a>
        <?php printf(__('%s&nbsp;in&nbsp;%s', 'wellearn'), $author_html, $cats_html); ?>
    </div>
</div>
